<?php
/**
 * ヘルパークラス - 共通ユーティリティ関数
 */
class AAB_Helper {
    
    private static $errors = array();
    
    /**
     * エラーログ記録
     */
    public static function log_error($message, $context = array()) {
        if (defined('WP_DEBUG') && WP_DEBUG) {
            error_log(sprintf(
                '[AAB Error] %s | Context: %s',
                $message,
                json_encode($context)
            ));
        }
        self::$errors[] = $message;
    }
    
    /**
     * エラー取得
     */
    public static function get_errors() {
        return self::$errors;
    }
    
    /**
     * エラークリア
     */
    public static function clear_errors() {
        self::$errors = array();
    }
    
    /**
     * ASIN検証
     */
    public static function validate_asin($asin) {
        $asin = preg_replace('/[^A-Z0-9]/i', '', $asin);
        if (!preg_match('/^[A-Z0-9]{10}$/i', $asin)) {
            return false;
        }
        return $asin;
    }
    
    /**
     * アフィリエイトタグ検証
     */
    public static function validate_affiliate_tag($tag) {
        if (!preg_match('/^[a-z0-9\-]+$/i', $tag)) {
            return false;
        }
        return $tag;
    }
    
    /**
     * Amazon URL生成
     */
    public static function generate_amazon_url($asin, $tag, $marketplace = 'co.jp') {
        $domains = array(
            'co.jp' => 'amazon.co.jp',
            'com' => 'amazon.com',
            'co.uk' => 'amazon.co.uk',
            'de' => 'amazon.de',
            'fr' => 'amazon.fr'
        );
        
        $domain = isset($domains[$marketplace]) ? $domains[$marketplace] : 'amazon.co.jp';
        return sprintf('https://www.%s/dp/%s?tag=%s', $domain, $asin, $tag);
    }
    
    /**
     * URL検証
     */
    public static function validate_url($url) {
        return filter_var($url, FILTER_VALIDATE_URL) !== false;
    }
}