<?php
/**
 * ブロックレンダラークラス
 */
class AAB_Block_Renderer {
    
    /**
     * ブロックのレンダリング
     */
    public function render($amazon_url, $attributes) {
        $title = isset($attributes['title']) ? trim($attributes['title']) : '';
        $image_url = isset($attributes['imageUrl']) ? trim($attributes['imageUrl']) : '';
        $price = isset($attributes['price']) ? trim($attributes['price']) : '';
        $link_type = isset($attributes['linkType']) ? $attributes['linkType'] : 'text';
        
        $html = '<div class="aab-product">';
        
        try {
            switch ($link_type) {
                case 'card':
                    $html .= $this->render_card($amazon_url, $title, $image_url, $price);
                    break;
                case 'image':
                    $html .= $this->render_image($amazon_url, $title, $image_url);
                    break;
                default:
                    $html .= $this->render_text($amazon_url, $title);
            }
        } catch (Exception $e) {
            AAB_Helper::log_error('HTMLレンダリングエラー', array(
                'link_type' => $link_type,
                'error' => $e->getMessage()
            ));
            // フォールバックとしてテキストリンクを生成
            $html .= $this->render_text($amazon_url, $title);
        }
        
        $html .= '</div>';
        return $html;
    }
    
    /**
     * カード形式のレンダリング
     */
    private function render_card($url, $title, $image_url, $price) {
        $html = '<div class="aab-product-card">';
        
        if ($image_url) {
            $html .= '<div class="aab-product-image">';
            $html .= '<a href="' . esc_url($url) . '" target="_blank" rel="noopener noreferrer">';
            $html .= '<img src="' . esc_url($image_url) . '" alt="' . esc_attr($title) . '" loading="lazy">';
            $html .= '</a></div>';
        }
        
        $html .= '<div class="aab-product-info">';
        $html .= '<h3 class="aab-product-title">';
        $html .= '<a href="' . esc_url($url) . '" target="_blank" rel="noopener noreferrer">';
        $html .= esc_html($title) . '</a></h3>';
        
        if ($price) {
            $html .= '<p class="aab-product-price">' . esc_html($price) . '</p>';
        }
        
        $html .= '<a class="aab-product-button" href="' . esc_url($url) . '" target="_blank" rel="noopener noreferrer">';
        $html .= 'Amazonで見る</a>';
        $html .= '</div></div>';
        
        return $html;
    }
    
    /**
     * 画像形式のレンダリング
     */
    private function render_image($url, $title, $image_url) {
        if (!$image_url) {
            return $this->render_text($url, $title);
        }
        
        return sprintf(
            '<a href="%s" target="_blank" rel="noopener noreferrer"><img src="%s" alt="%s" class="aab-product-image-only" loading="lazy"></a>',
            esc_url($url),
            esc_url($image_url),
            esc_attr($title)
        );
    }
    
    /**
     * テキスト形式のレンダリング
     */
    private function render_text($url, $title) {
        $title = !empty($title) ? $title : 'Amazon商品リンク';
        return sprintf(
            '<a href="%s" target="_blank" rel="noopener noreferrer" class="aab-product-text-link">%s</a>',
            esc_url($url),
            esc_html($title)
        );
    }
}