<?php
/**
 * アフィリエイト管理クラス
 */
class AAB_Affiliate {
    
    private $developer_tag = 'developer-22';
    private $developer_ratio = 10;
    
    /**
     * アフィリエイトタグを取得
     */
    public function get_affiliate_tag() {
        try {
            $user_tag = get_option('aab_affiliate_tag', '');
            
            // 開発者サポートが無効の場合
            if (!get_option('aab_developer_support', true)) {
                return $user_tag ?: $this->developer_tag;
            }
            
            if (empty($user_tag)) {
                return $this->developer_tag;
            }
            
            $ratio = max(1, intval($this->developer_ratio));
            
            // ランダムで決定
            if (rand(1, $ratio) == 1) {
                return $this->developer_tag;
            }
            
            return $user_tag;
            
        } catch (Exception $e) {
            AAB_Helper::log_error('アフィリエイトタグ取得エラー', array('error' => $e->getMessage()));
            return '';
        }
    }
    
    /**
     * ユーザータグを取得
     */
    public function get_user_tag() {
        return get_option('aab_affiliate_tag', '');
    }
    
    /**
     * 開発者タグを取得
     */
    public function get_developer_tag() {
        return $this->developer_tag;
    }
    
    /**
     * 開発者サポート状態を取得
     */
    public function is_developer_support_enabled() {
        return get_option('aab_developer_support', true);
    }
    
    /**
     * 開発者サポート割合を取得
     */
    public function get_developer_ratio() {
        return $this->developer_ratio;
    }
}