<?php
/**
 * Plugin Name: Amazon Affiliate Block for Gutenberg
 * Plugin URI: https://example.com/
 * Description: Gutenberg対応のAmazonアフィリエイトリンク挿入プラグイン
 * Version: 1.0.0
 * Author: Your Name
 * License: GPL v2 or later
 * Text Domain: amazon-affiliate-block
 */

// 直接アクセスを防ぐ
if (!defined('ABSPATH')) {
    exit;
}

// プラグインの定数定義
define('AAB_PLUGIN_FILE', __FILE__);
define('AAB_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('AAB_PLUGIN_URL', plugin_dir_url(__FILE__));
define('AAB_PLUGIN_BASENAME', plugin_basename(__FILE__));
define('AAB_PLUGIN_VERSION', '1.0.0');

// 自動読み込み
spl_autoload_register(function ($class) {
    $prefix = 'AAB_';
    if (strpos($class, $prefix) !== 0) {
        return;
    }
    
    $class_file = 'class-' . strtolower(str_replace('_', '-', $class)) . '.php';
    $file = AAB_PLUGIN_DIR . 'includes/' . $class_file;
    
    if (file_exists($file)) {
        require_once $file;
    }
});

// 必須ファイルの読み込み
require_once AAB_PLUGIN_DIR . 'includes/class-aab-core.php';

// プラグインの初期化
function aab_init() {
    try {
        AAB_Core::get_instance();
    } catch (Exception $e) {
        if (defined('WP_DEBUG') && WP_DEBUG) {
            error_log('[AAB Fatal Error] プラグインの初期化に失敗しました: ' . $e->getMessage());
        }
    }
}
add_action('plugins_loaded', 'aab_init');

// プラグイン有効化
register_activation_hook(__FILE__, array('AAB_Core', 'activate'));

// プラグイン無効化
register_deactivation_hook(__FILE__, array('AAB_Core', 'deactivate'));